/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import org.jruby.RubyModule;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Binding;
import org.jruby.runtime.Block;
import org.jruby.runtime.BlockBody;
import org.jruby.runtime.BlockCallback;
import org.jruby.runtime.Signature;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ArraySupport;

public class CallBlock
extends BlockBody {
    private final BlockCallback callback;
    private final StaticScope dummyScope;

    public static Block newCallClosure(IRubyObject self2, RubyModule imClass, Signature signature, BlockCallback callback, ThreadContext context) {
        Binding binding2 = context.currentBinding(self2, Visibility.PUBLIC);
        CallBlock body = new CallBlock(signature, callback, context);
        return new Block(body, binding2);
    }

    @Deprecated
    public static Block newCallClosure(IRubyObject self2, RubyModule imClass, Arity arity2, BlockCallback callback, ThreadContext context) {
        return CallBlock.newCallClosure(self2, imClass, Signature.from(arity2), callback, context);
    }

    private CallBlock(Signature signature, BlockCallback callback, ThreadContext context) {
        super(signature);
        this.callback = callback;
        this.dummyScope = context.runtime.getStaticScopeFactory().getDummyScope();
    }

    private IRubyObject[] adjustArgs(Block block, IRubyObject[] args2) {
        Signature signature = block.getSignature();
        int required = signature.required();
        if (signature.isFixed() && required > 0 && required < args2.length) {
            args2 = ArraySupport.newCopy(args2, required);
        }
        return args2;
    }

    @Override
    public IRubyObject call(ThreadContext context, Block block, IRubyObject[] args2) {
        return this.callback.call(context, this.adjustArgs(block, args2), Block.NULL_BLOCK);
    }

    @Override
    public IRubyObject call(ThreadContext context, Block block, IRubyObject[] args2, Block blockArg) {
        return this.callback.call(context, this.adjustArgs(block, args2), blockArg);
    }

    @Override
    public IRubyObject yieldSpecific(ThreadContext context, Block block) {
        return this.callback.call(context, IRubyObject.NULL_ARRAY, Block.NULL_BLOCK);
    }

    @Override
    public IRubyObject yieldSpecific(ThreadContext context, Block block, IRubyObject arg0) {
        return this.callback.call(context, new IRubyObject[]{arg0}, Block.NULL_BLOCK);
    }

    @Override
    protected IRubyObject doYield(ThreadContext context, Block block, IRubyObject value2) {
        return this.callback.call(context, new IRubyObject[]{value2}, Block.NULL_BLOCK);
    }

    @Override
    protected IRubyObject doYield(ThreadContext context, Block block, IRubyObject[] args2, IRubyObject self2) {
        return this.callback.call(context, this.adjustArgs(block, args2), Block.NULL_BLOCK);
    }

    @Override
    public StaticScope getStaticScope() {
        return this.dummyScope;
    }

    @Override
    public void setStaticScope(StaticScope newScope) {
    }

    @Override
    public String getFile() {
        return "(internal)";
    }

    @Override
    public int getLine() {
        return -1;
    }
}

